/**
 * Test script to verify template message transformation with real API data
 */

// Sample API message data from your actual response
const sampleTemplateMessage = {
  "id": 1435476,
  "message_text": "{\"to\":917319950350,\"type\":\"template\",\"template\":{\"name\":\"navarti_template\",\"language\":{\"code\":\"en_US\"},\"components\":[{\"type\":\"HEADER\",\"parameters\":[{\"type\":\"IMAGE\",\"image\":{\"link\":\"https:\\/\\/app.getgabs.com\\/customers\\/mediafile\\/newfiles\\/uploads\\/17587145893638266440352.jpeg\"}}]},{\"type\":\"BODY\",\"parameters\":[{\"type\":\"text\",\"text\":\"Name\"}]}]},\"recipient_type\":\"individual\",\"messaging_product\":\"whatsapp\"}",
  "message_type": "template",
  "template_data": "{\"data\":[{\"name\":\"navarti_template\",\"parameter_format\":\"POSITIONAL\",\"components\":[{\"type\":\"HEADER\",\"format\":\"IMAGE\",\"example\":{\"header_handle\":[\"https:\\/\\/scontent.whatsapp.net\\/v\\/t61.29466-34\\/534425637_2239230586548931_1696134097633277172_n.jpg?ccb=1-7&_nc_sid=8b1bef&_nc_ohc=sCpoAIr0HloQ7kNvwG78o98&_nc_oc=AdnlZsumii_5xWcPw5MD4wCUhqzF9gFFuq-aRV63n3Pta5GhZIMyk78hEfBbXOapoa8&_nc_zt=3&_nc_ht=scontent.whatsapp.net&edm=AH51TzQEAAAA&_nc_gid=LFg5x_nWyZ4OoZmKIrak5A&oh=01_Q5Aa2gESO9UAmpRtAJhriyuyJznuARZHpfMXuC_0w_y9_nepwA&oe=68FB46D6\"]}},{\"type\":\"BODY\",\"text\":\"\\u2728 Happy Navratri  {{1}} \\u2728\\r\\n\\r\\nMay the divine blessings of Maa Durga\\r\\nbring peace, happiness, and prosperity into your life.\\r\\nWishing you and your family a joyful and blessed Navratri. \\ud83c\\udf3a\\ud83d\\ude4f\",\"example\":{\"body_text\":[[\"Name\"]]}}],\"language\":\"en_US\",\"status\":\"APPROVED\",\"category\":\"MARKETING\",\"id\":\"2239230583215598\"}]}",
  "sender": 2,
  "delivery_status": "delivered",
  "created_at": "2025-09-24T11:49:50.000000Z"
};

console.log('🧪 Testing Template Message Transformation\n');

console.log('📥 Input API Message:');
console.log('  Message Type:', sampleTemplateMessage.message_type);
console.log('  Has template_data:', !!sampleTemplateMessage.template_data);
console.log('  Has message_text:', !!sampleTemplateMessage.message_text);

// Parse template_data to see its structure
if (sampleTemplateMessage.template_data) {
  try {
    const templateData = JSON.parse(sampleTemplateMessage.template_data);
    console.log('\n📋 Template Data Structure:');
    console.log('  Template Name:', templateData.data?.[0]?.name);
    console.log('  Language:', templateData.data?.[0]?.language);
    console.log('  Components Count:', templateData.data?.[0]?.components?.length);
    
    templateData.data?.[0]?.components?.forEach((component, index) => {
      console.log(`  Component ${index + 1}:`, component.type, component.format || '');
    });
    
    // Show what the transformed template should look like
    const templateForPreview = {
      template: {
        name: templateData.data?.[0]?.name,
        language: { code: templateData.data?.[0]?.language || 'en_US' },
        components: templateData.data?.[0]?.components || []
      }
    };
    
    console.log('\n🔄 Transformed Template for Preview:');
    console.log(JSON.stringify(templateForPreview, null, 2));
    
  } catch (e) {
    console.error('❌ Failed to parse template_data:', e.message);
  }
}

// Parse message_text to see its structure
if (sampleTemplateMessage.message_text) {
  try {
    const messageData = JSON.parse(sampleTemplateMessage.message_text);
    console.log('\n📨 Message Text Structure:');
    console.log('  Type:', messageData.type);
    console.log('  Template Name:', messageData.template?.name);
    console.log('  Components Count:', messageData.template?.components?.length);
  } catch (e) {
    console.error('❌ Failed to parse message_text:', e.message);
  }
}

console.log('\n✅ Key Findings:');
console.log('1. template_data contains the actual template structure with proper formatting');
console.log('2. template_data has the body text with proper content');
console.log('3. message_text contains the API call structure, not the template content');
console.log('4. We should use template_data for preview generation');

console.log('\n🎯 Expected Behavior:');
console.log('- Template Name: navarti_template');
console.log('- Should show image header');
console.log('- Should show formatted body text with Navratri message');
console.log('- Should replace {{1}} with customer name');
