/**
 * Test script to verify chat API message transformation
 */

import { transformMessageData } from './app/utils/chatApi.js';

// Sample API message data from your actual API response
const sampleMessages = [
  // Template message (Navratri template)
  {
    "id": 1435476,
    "message_text": "{\"to\":917319950350,\"type\":\"template\",\"template\":{\"name\":\"navarti_template\",\"language\":{\"code\":\"en_US\"},\"components\":[{\"type\":\"HEADER\",\"parameters\":[{\"type\":\"IMAGE\",\"image\":{\"link\":\"https:\\/\\/app.getgabs.com\\/customers\\/mediafile\\/newfiles\\/uploads\\/17587145893638266440352.jpeg\"}}]},{\"type\":\"BODY\",\"parameters\":[{\"type\":\"text\",\"text\":\"Name\"}]}]},\"recipient_type\":\"individual\",\"messaging_product\":\"whatsapp\"}",
    "message_type": "template",
    "template_data": "{\"data\":[{\"name\":\"navarti_template\",\"parameter_format\":\"POSITIONAL\",\"components\":[{\"type\":\"HEADER\",\"format\":\"IMAGE\",\"example\":{\"header_handle\":[\"https:\\/\\/scontent.whatsapp.net\\/v\\/t61.29466-34\\/534425637_2239230586548931_1696134097633277172_n.jpg?ccb=1-7&_nc_sid=8b1bef&_nc_ohc=sCpoAIr0HloQ7kNvwG78o98&_nc_oc=AdnlZsumii_5xWcPw5MD4wCUhqzF9gFFuq-aRV63n3Pta5GhZIMyk78hEfBbXOapoa8&_nc_zt=3&_nc_ht=scontent.whatsapp.net&edm=AH51TzQEAAAA&_nc_gid=LFg5x_nWyZ4OoZmKIrak5A&oh=01_Q5Aa2gESO9UAmpRtAJhriyuyJznuARZHpfMXuC_0w_y9_nepwA&oe=68FB46D6\"]}},{\"type\":\"BODY\",\"text\":\"\\u2728 Happy Navratri  {{1}} \\u2728\\r\\n\\r\\nMay the divine blessings of Maa Durga\\r\\nbring peace, happiness, and prosperity into your life.\\r\\nWishing you and your family a joyful and blessed Navratri. \\ud83c\\udf3a\\ud83d\\ude4f\",\"example\":{\"body_text\":[[\"Name\"]]}}],\"language\":\"en_US\",\"status\":\"APPROVED\",\"category\":\"MARKETING\",\"id\":\"2239230583215598\"}]}",
    "sender": 2,
    "delivery_status": "delivered",
    "created_at": "2025-09-24T11:49:50.000000Z"
  },
  
  // Image message
  {
    "id": 1435288,
    "message_text": "17587112047916555295959278482683849.png",
    "message_type": "image",
    "media_type": "image/png",
    "caption_text": null,
    "sender": 2,
    "delivery_status": "read",
    "created_at": "2025-09-24T10:53:25.000000Z"
  },
  
  // Text message
  {
    "id": 1435270,
    "message_text": "Hi",
    "message_type": "text",
    "sender": 1,
    "delivery_status": null,
    "created_at": "2025-09-24T10:44:05.000000Z"
  },
  
  // Interactive/Flow message
  {
    "id": 1429902,
    "message_text": "{\"to\":\"917319950350\",\"type\":\"interactive\",\"interactive\":{\"body\":{\"text\":\"Write Body Text Here\"},\"type\":\"flow\",\"action\":{\"name\":\"flow\",\"parameters\":{\"flow_id\":\"2038804670277173\",\"flow_cta\":\"flow text\",\"flow_token\":\"b8f06976-3d8d-4c2d-9955-2d47371ff53a\",\"flow_action\":\"navigate\",\"flow_action_payload\":{\"screen\":\"screenA\"},\"flow_message_version\":\"3\",\"mode\":\"draft\"}},\"footer\":{\"text\":\"Write Footer Text Here\"},\"header\":{\"text\":\"Write Header Text Here\",\"type\":\"text\"}},\"recipient_type\":\"individual\",\"messaging_product\":\"whatsapp\"}",
    "message_type": "template",
    "sender": 2,
    "delivery_status": "read",
    "created_at": "2025-09-23T13:28:31.000000Z"
  }
];

console.log('🧪 Testing Chat API Message Transformation\n');

sampleMessages.forEach((apiMessage, index) => {
  console.log(`\n--- Test ${index + 1}: ${apiMessage.message_type.toUpperCase()} Message ---`);
  console.log('📥 Input API Message:');
  console.log(`  ID: ${apiMessage.id}`);
  console.log(`  Type: ${apiMessage.message_type}`);
  console.log(`  Sender: ${apiMessage.sender === 1 ? 'Customer' : 'Admin'}`);
  console.log(`  Text Preview: ${apiMessage.message_text.substring(0, 100)}${apiMessage.message_text.length > 100 ? '...' : ''}`);
  
  try {
    const transformedMessage = transformMessageData(apiMessage);
    
    console.log('\n📤 Transformed Message:');
    console.log(`  ID: ${transformedMessage.id}`);
    console.log(`  Type: ${transformedMessage.type}`);
    console.log(`  Message Type: ${transformedMessage.messageType}`);
    console.log(`  Content: ${transformedMessage.content.substring(0, 100)}${transformedMessage.content.length > 100 ? '...' : ''}`);
    
    if (transformedMessage.templateName) {
      console.log(`  Template Name: ${transformedMessage.templateName}`);
    }
    
    if (transformedMessage.mediaUrl) {
      console.log(`  Media URL: ${transformedMessage.mediaUrl}`);
    }
    
    if (transformedMessage.fileName) {
      console.log(`  File Name: ${transformedMessage.fileName}`);
    }
    
    console.log(`  Status: ${transformedMessage.status}`);
    console.log(`  Timestamp: ${transformedMessage.timestamp.toISOString()}`);
    
    console.log('✅ Transformation successful!');
    
  } catch (error) {
    console.log('❌ Transformation failed:');
    console.error(`  Error: ${error.message}`);
  }
});

console.log('\n🎉 Test completed! Check the results above to verify message transformation.');
console.log('\n📋 Summary of expected behavior:');
console.log('  1. Template messages should have messageType="template" and templateName');
console.log('  2. Image messages should have messageType="image" and mediaUrl');
console.log('  3. Text messages should have messageType="text" and plain content');
console.log('  4. Interactive messages should have messageType="interactive" and templateName');
