// scripts/static-export.js
import { execSync } from "child_process";
import fs from "fs";
import path from "path";

console.log("🛠️ Building Remix app...");
execSync("npx remix build", { stdio: "inherit" });

const clientDir = path.resolve("build/client");
const distDir = path.resolve("dist");

// Remove any previous dist folder
fs.rmSync(distDir, { recursive: true, force: true });
fs.mkdirSync(distDir, { recursive: true });

// Copy Remix client build
if (fs.existsSync(clientDir)) {
  fs.cpSync(clientDir, distDir, { recursive: true });
}

// Copy public folder (static assets)
if (fs.existsSync("public")) {
  fs.cpSync("public", distDir, { recursive: true });
}

// Create a minimal index.html (Remix doesn’t produce one)
const indexPath = path.join(distDir, "index.html");
fs.writeFileSync(
  indexPath,
  `<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8" />
    <title>Remix App</title>
  </head>
  <body>
    <div id="root"></div>
    <script type="module" src="/entry.client.js"></script>
  </body>
</html>`
);

console.log("✅ Static files ready in ./dist");
