'use strict';

var abstractMigrationEngine = require('./abstract-migration-engine.js');
var types = require('./types.js');

class RdbmsSessionStorageMigrator extends abstractMigrationEngine.AbstractMigrationEngine {
    constructor(dbConnection, opts = {}, migrations) {
        super(dbConnection, {
            ...types.defaultRdbmsSessionStorageMigratorOptions,
            ...opts,
        }, migrations);
    }
    async hasMigrationBeenApplied(migrationName) {
        await this.ready;
        const query = `
      SELECT * FROM ${this.options.migrationDBIdentifier}
      WHERE ${this.getOptions().migrationNameColumnName} =
        ${this.connection.getArgumentPlaceholder(1)};
    `;
        const rows = await this.connection.query(query, [migrationName]);
        return rows.length === 1;
    }
    async saveAppliedMigration(migrationName) {
        await this.ready;
        const insert = `
          INSERT INTO ${this.options.migrationDBIdentifier} (${this.getOptions().migrationNameColumnName})
          VALUES(${this.connection.getArgumentPlaceholder(1)});
        `;
        await this.connection.query(insert, [migrationName]);
    }
    getOptions() {
        return this.options;
    }
}

exports.RdbmsSessionStorageMigrator = RdbmsSessionStorageMigrator;
//# sourceMappingURL=rdbms-session-storage-migrator.js.map
