'use strict';

var types = require('./types.js');

class AbstractMigrationEngine {
    options;
    connection;
    ready;
    migrations;
    constructor(db, opts = {}, migrations) {
        this.options = { ...types.defaultSessionStorageMigratorOptions, ...opts };
        this.connection = db;
        this.migrations = migrations;
        this.ready = this.initMigrationPersistence();
    }
    async applyMigrations(databaseReady) {
        await databaseReady;
        await this.ready;
        for (const { migrationName, migrationFunction } of this.getMigrationList()) {
            const migrationApplied = await this.hasMigrationBeenApplied(migrationName);
            if (!migrationApplied) {
                await migrationFunction(this.connection);
                await this.saveAppliedMigration(migrationName);
            }
        }
        return Promise.resolve();
    }
    getMigrationList() {
        return this.migrations;
    }
}

exports.AbstractMigrationEngine = AbstractMigrationEngine;
//# sourceMappingURL=abstract-migration-engine.js.map
