import '@shopify/shopify-api/adapters/web-api';
import { ShopifyRestResources } from '@shopify/shopify-api';
import { SessionStorage } from '@shopify/shopify-app-session-storage';
import { type AppConfigArg } from './config-types';
import { type BasicParams, type ShopifyApp } from './types';
import { FutureFlagOptions } from './future/flags';
/**
 * Creates an object your app will use to interact with Shopify.
 *
 * @param appConfig Configuration options for your Shopify app, such as the scopes your app needs.
 * @returns `ShopifyApp` An object constructed using your appConfig.  It has methods for interacting with Shopify.
 *
 * @example
 * <caption>The minimum viable configuration</caption>
 * ```ts
 * // /shopify.server.ts
 * import { shopifyApp } from "@shopify/shopify-app-remix/server";
 *
 * const shopify = shopifyApp({
 *   apiKey: process.env.SHOPIFY_API_KEY!,
 *   apiSecretKey: process.env.SHOPIFY_API_SECRET!,
 *   scopes: process.env.SCOPES?.split(",")!,
 *   appUrl: process.env.SHOPIFY_APP_URL!,
 * });
 * export default shopify;
 * ```
 */
export declare function shopifyApp<Config extends AppConfigArg<Resources, Storage, Future>, Resources extends ShopifyRestResources, Storage extends SessionStorage, Future extends FutureFlagOptions = Config['future']>(appConfig: Readonly<Config>): ShopifyApp<Config>;
export declare function deriveApi(appConfig: AppConfigArg): BasicParams['api'];
//# sourceMappingURL=shopify-app.d.ts.map