import { createOrLoadOfflineSession } from '../../authenticate/helpers/create-or-load-offline-session.mjs';
import { SessionNotFoundError } from '../../errors.mjs';
import { storefrontClientFactory } from '../../clients/storefront/factory.mjs';

function unauthenticatedStorefrontContextFactory(params) {
    return async (shop) => {
        const session = await createOrLoadOfflineSession(shop, params);
        if (!session) {
            throw new SessionNotFoundError(`Could not find a session for shop ${shop} when creating unauthenticated storefront context`);
        }
        return {
            session,
            storefront: storefrontClientFactory({ params, session }),
        };
    };
}

export { unauthenticatedStorefrontContextFactory };
//# sourceMappingURL=factory.mjs.map
