import { authenticateCheckoutFactory } from './checkout/authenticate.mjs';
import { authenticateAppProxyFactory } from './appProxy/authenticate.mjs';
import { authenticateCustomerAccountFactory } from './customer-account/authenticate.mjs';
import { authenticatePOSFactory } from './pos/authenticate.mjs';

function authenticatePublicFactory(params) {
    const authenticateCheckout = authenticateCheckoutFactory(params);
    const authenticateAppProxy = authenticateAppProxyFactory(params);
    const authenticateCustomerAccount = authenticateCustomerAccountFactory(params);
    const authenticatePOS = authenticatePOSFactory(params);
    const context = {
        checkout: authenticateCheckout,
        appProxy: authenticateAppProxy,
        customerAccount: authenticateCustomerAccount,
        pos: authenticatePOS,
    };
    return context;
}

export { authenticatePublicFactory };
//# sourceMappingURL=factory.mjs.map
