import { ensureCORSHeadersFactory } from './ensure-cors-headers.mjs';

function respondToOptionsRequest(params, request, corsHeaders) {
    if (request.method === 'OPTIONS') {
        const ensureCORSHeaders = ensureCORSHeadersFactory(params, request, corsHeaders);
        throw ensureCORSHeaders(new Response(null, {
            status: 204,
            headers: {
                'Access-Control-Max-Age': '7200',
            },
        }));
    }
}

export { respondToOptionsRequest };
//# sourceMappingURL=respond-to-options-request.mjs.map
