import { redirectToBouncePage } from '../admin/helpers/redirect-to-bounce-page.mjs';
import { RETRY_INVALID_SESSION_HEADER } from '../const.mjs';

function respondToInvalidSessionToken({ params, request, retryRequest = false, }) {
    const { api, logger, config } = params;
    const isDocumentRequest = !request.headers.get('authorization');
    if (isDocumentRequest) {
        return redirectToBouncePage({ config }, new URL(request.url));
    }
    throw new Response(undefined, {
        status: 401,
        statusText: 'Unauthorized',
        headers: retryRequest ? RETRY_INVALID_SESSION_HEADER : {},
    });
}

export { respondToInvalidSessionToken };
//# sourceMappingURL=respond-to-invalid-session-token.mjs.map
