import { AuthScopes } from '@shopify/shopify-api';
import { fetchScopeDetail } from './client/fetch-scopes-details.mjs';

function queryScopesFactory(params, session, admin) {
    return async function queryScopes() {
        const { logger } = params;
        logger.debug('Querying scopes details: ', {
            shop: session.shop,
        });
        const scopesDetail = await fetchScopeDetail(admin);
        return mapFetchScopeDetail(scopesDetail);
    };
}
function mapFetchScopeDetail(scopesDetailResponse) {
    const appInformation = scopesDetailResponse.app;
    const granted = new AuthScopes(appInformation.installation.accessScopes.map((scope) => scope.handle)).toArray(true);
    const required = new AuthScopes(appInformation.requestedAccessScopes.map((scope) => scope.handle)).toArray(true);
    const optional = new AuthScopes(appInformation.optionalAccessScopes.map((scope) => scope.handle)).toArray(true);
    return {
        granted,
        required,
        optional,
    };
}

export { mapFetchScopeDetail, queryScopesFactory };
//# sourceMappingURL=query.mjs.map
