import { REAUTH_URL_HEADER } from '../../const.mjs';

function redirectWithAppBridgeHeaders(redirectUri) {
    throw new Response(undefined, {
        status: 401,
        statusText: 'Unauthorized',
        headers: getAppBridgeHeaders(redirectUri),
    });
}
function getAppBridgeHeaders(url) {
    return new Headers({ [REAUTH_URL_HEADER]: url });
}

export { getAppBridgeHeaders, redirectWithAppBridgeHeaders };
//# sourceMappingURL=redirect-with-app-bridge-headers.mjs.map
