import { redirect } from '@remix-run/server-runtime';

async function redirectToShopifyOrAppRoot(request, params, responseHeaders) {
    const { api } = params;
    const url = new URL(request.url);
    const host = api.utils.sanitizeHost(url.searchParams.get('host'));
    const shop = api.utils.sanitizeShop(url.searchParams.get('shop'));
    const redirectUrl = api.config.isEmbeddedApp
        ? await api.auth.getEmbeddedAppUrl({ rawRequest: request })
        : `/?shop=${shop}&host=${encodeURIComponent(host)}`;
    throw redirect(redirectUrl, { headers: responseHeaders });
}

export { redirectToShopifyOrAppRoot };
//# sourceMappingURL=redirect-to-shopify-or-app-root.mjs.map
