import { redirectToShopifyOrAppRoot } from './redirect-to-shopify-or-app-root.mjs';

const ensureAppIsEmbeddedIfRequired = async (params, request) => {
    const { api, logger, config } = params;
    const url = new URL(request.url);
    const shop = url.searchParams.get('shop');
    if (api.config.isEmbeddedApp && url.searchParams.get('embedded') !== '1') {
        logger.debug('App is not embedded, redirecting to Shopify', { shop });
        await redirectToShopifyOrAppRoot(request, { api});
    }
};

export { ensureAppIsEmbeddedIfRequired };
//# sourceMappingURL=ensure-app-is-embedded-if-required.mjs.map
