import { HttpResponseError } from '@shopify/shopify-api';
import '@remix-run/server-runtime';
import { redirectToAuthPage } from '../helpers/redirect-to-auth-page.mjs';
import { invalidateAccessToken } from '../../helpers/invalidate-access-token.mjs';
import 'isbot';
import '../../../types.mjs';
import { redirectOutOfApp } from './helpers.mjs';

function updateUsageCappedAmountFactory(params, request, session) {
    return async function updateUsageCappedAmount(options) {
        const { api, logger } = params;
        logger.debug('Updating usage subscription capped amount', {
            shop: session.shop,
            ...options,
        });
        let result;
        try {
            result = await api.billing.updateUsageCappedAmount({
                session,
                subscriptionLineItemId: options.subscriptionLineItemId,
                cappedAmount: options.cappedAmount,
            });
        }
        catch (error) {
            if (error instanceof HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', {
                    shop: session.shop,
                });
                await invalidateAccessToken(params, session);
                throw await redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
        throw redirectOutOfApp(params, request, result.confirmationUrl, session.shop);
    };
}

export { updateUsageCappedAmountFactory };
//# sourceMappingURL=update-usage-subscription-capped-amount.mjs.map
