import { HttpResponseError } from '@shopify/shopify-api';
import '@remix-run/server-runtime';
import { redirectToAuthPage } from '../helpers/redirect-to-auth-page.mjs';
import { invalidateAccessToken } from '../../helpers/invalidate-access-token.mjs';
import 'isbot';
import '../../../types.mjs';

function requireBillingFactory(params, request, session) {
    const { api, logger } = params;
    return async function requireBilling(options) {
        const logContext = {
            shop: session.shop,
            plans: options.plans,
            isTest: options.isTest,
        };
        logger.debug('Checking billing for the shop', logContext);
        let data;
        try {
            data = await api.billing.check({
                session,
                plans: options.plans,
                isTest: options.isTest,
                returnObject: true,
            });
        }
        catch (error) {
            if (error instanceof HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', logContext);
                await invalidateAccessToken(params, session);
                throw await redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
        if (!data.hasActivePayment) {
            logger.debug('Billing check failed', logContext);
            throw await options.onFailure(new Error('Billing check failed'));
        }
        logger.debug('Billing check succeeded', logContext);
        return data;
    };
}

export { requireBillingFactory };
//# sourceMappingURL=require.mjs.map
