import { HttpResponseError } from '@shopify/shopify-api';
import '@remix-run/server-runtime';
import { redirectToAuthPage } from '../helpers/redirect-to-auth-page.mjs';
import { invalidateAccessToken } from '../../helpers/invalidate-access-token.mjs';
import 'isbot';
import '../../../types.mjs';
import { redirectOutOfApp } from './helpers.mjs';

function requestBillingFactory(params, request, session) {
    return async function requestBilling({ plan, isTest, returnUrl, ...overrides }) {
        const { api, logger } = params;
        logger.info('Requesting billing', {
            shop: session.shop,
            plan,
            isTest,
            returnUrl,
        });
        let result;
        try {
            result = await api.billing.request({
                plan: plan,
                session,
                isTest,
                returnUrl,
                returnObject: true,
                ...overrides,
            });
        }
        catch (error) {
            if (error instanceof HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', {
                    shop: session.shop,
                });
                await invalidateAccessToken(params, session);
                throw await redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
        throw redirectOutOfApp(params, request, result.confirmationUrl, session.shop);
    };
}

export { requestBillingFactory };
//# sourceMappingURL=request.mjs.map
