import { HttpResponseError } from '@shopify/shopify-api';
import '@remix-run/server-runtime';
import { redirectToAuthPage } from '../helpers/redirect-to-auth-page.mjs';
import { invalidateAccessToken } from '../../helpers/invalidate-access-token.mjs';
import 'isbot';
import '../../../types.mjs';

function cancelBillingFactory(params, request, session) {
    return async function cancelBilling(options) {
        const { api, logger } = params;
        logger.debug('Cancelling billing', { shop: session.shop, ...options });
        try {
            return await api.billing.cancel({
                session,
                subscriptionId: options.subscriptionId,
                isTest: options.isTest,
                prorate: options.prorate,
            });
        }
        catch (error) {
            if (error instanceof HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', {
                    shop: session.shop,
                });
                await invalidateAccessToken(params, session);
                throw await redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
    };
}

export { cancelBillingFactory };
//# sourceMappingURL=cancel.mjs.map
