'use strict';

var createOrLoadOfflineSession = require('../../authenticate/helpers/create-or-load-offline-session.js');
var errors = require('../../errors.js');
var factory = require('../../clients/admin/factory.js');

function unauthenticatedAdminContextFactory(params) {
    return async (shop) => {
        const session = await createOrLoadOfflineSession.createOrLoadOfflineSession(shop, params);
        if (!session) {
            throw new errors.SessionNotFoundError(`Could not find a session for shop ${shop} when creating unauthenticated admin context`);
        }
        return {
            session,
            admin: factory.adminClientFactory({ params, session }),
        };
    };
}

exports.unauthenticatedAdminContextFactory = unauthenticatedAdminContextFactory;
//# sourceMappingURL=factory.js.map
