'use strict';

function restClientFactory({ params, handleClientError, session, }) {
    const { api } = params;
    const client = new RemixRestClient({
        params,
        handleClientError,
        session,
    });
    if (api.rest) {
        client.resources = {};
        const RestResourceClient = restResourceClientFactory({
            params,
            handleClientError,
            session,
        });
        Object.entries(api.rest).forEach(([name, resource]) => {
            class RemixResource extends resource {
                static Client = RestResourceClient;
            }
            Reflect.defineProperty(RemixResource, 'name', {
                value: name,
            });
            Reflect.set(client.resources, name, RemixResource);
        });
    }
    return client;
}
class RemixRestClient {
    session;
    params;
    handleClientError;
    constructor({ params, session, handleClientError }) {
        this.params = params;
        this.handleClientError = handleClientError;
        this.session = session;
    }
    /**
     * Performs a GET request on the given path.
     *
     * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
     */
    async get(params) {
        return this.makeRequest({
            method: 'GET',
            ...params,
        });
    }
    /**
     * Performs a POST request on the given path.
     *
     * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
     */
    async post(params) {
        return this.makeRequest({
            method: 'POST',
            ...params,
        });
    }
    /**
     * Performs a PUT request on the given path.
     *
     * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
     */
    async put(params) {
        return this.makeRequest({
            method: 'PUT',
            ...params,
        });
    }
    /**
     * Performs a DELETE request on the given path.
     *
     * @deprecated In a future major release REST will be removed from this package. Please see [all-in on graphql](https://www.shopify.com/ca/partners/blog/all-in-on-graphql).
     */
    async delete(params) {
        return this.makeRequest({
            method: 'DELETE',
            ...params,
        });
    }
    async makeRequest(params) {
        const originalClient = new this.params.api.clients.Rest({
            session: this.session,
        });
        const originalRequest = Reflect.get(originalClient, 'request');
        try {
            const apiResponse = await originalRequest.call(originalClient, params);
            // We use a separate client for REST requests and REST resources because we want to override the API library
            // client class to return a Response object instead.
            return new Response(JSON.stringify(apiResponse.body), {
                headers: apiResponse.headers,
            });
        }
        catch (error) {
            if (this.handleClientError) {
                throw await this.handleClientError({
                    error,
                    session: this.session,
                    params: this.params,
                });
            }
            else
                throw new Error(error);
        }
    }
}
function restResourceClientFactory({ params, handleClientError, session, }) {
    const { api } = params;
    const ApiClient = api.clients.Rest;
    return class RestResourceClient extends ApiClient {
        async request(requestParams) {
            const originalClient = new api.clients.Rest({ session });
            const originalRequest = Reflect.get(originalClient, 'request');
            try {
                // We just call through to the API library client, and handle the error response here, so that data parsing
                // behaves the same way.
                return await originalRequest.call(originalClient, requestParams);
            }
            catch (error) {
                if (handleClientError) {
                    throw await handleClientError({ error, params, session });
                }
                else
                    throw new Error(error);
            }
        }
    };
}

exports.restClientFactory = restClientFactory;
//# sourceMappingURL=rest.js.map
