'use strict';

var graphql = require('./graphql.js');
var rest = require('./rest.js');

function adminClientFactory({ params, handleClientError, session, }) {
    if (params.config.future.removeRest) {
        return {
            graphql: graphql.graphqlClientFactory({ params, session, handleClientError }),
        };
    }
    return {
        rest: rest.restClientFactory({
            params,
            session,
            handleClientError,
        }),
        graphql: graphql.graphqlClientFactory({ params, session, handleClientError }),
    };
}

exports.adminClientFactory = adminClientFactory;
//# sourceMappingURL=factory.js.map
