'use strict';

const IDENTIFIER_TTL_MS = 60000;
class IdempotentPromiseHandler {
    identifiers;
    constructor() {
        this.identifiers = new Map();
    }
    async handlePromise({ promiseFunction, identifier, }) {
        try {
            if (this.isPromiseRunnable(identifier)) {
                await promiseFunction();
            }
        }
        finally {
            this.clearStaleIdentifiers();
        }
        return Promise.resolve();
    }
    isPromiseRunnable(identifier) {
        if (!this.identifiers.has(identifier)) {
            this.identifiers.set(identifier, Date.now());
            return true;
        }
        return false;
    }
    async clearStaleIdentifiers() {
        this.identifiers.forEach((date, identifier, map) => {
            if (Date.now() - date > IDENTIFIER_TTL_MS) {
                map.delete(identifier);
            }
        });
    }
}

exports.IdempotentPromiseHandler = IdempotentPromiseHandler;
//# sourceMappingURL=idempotent-promise-handler.js.map
