'use strict';

var shopifyApi = require('@shopify/shopify-api');

const FILE_URI_MATCH = /\/\/\//;
const INVALID_RELATIVE_URL = /[/\\][/\\]/;
const WHITESPACE_CHARACTER = /\s/;
const VALID_PROTOCOLS = ['https:', 'http:'];
function isSafe(domain, redirectUrl, requireSSL = true) {
    if (typeof redirectUrl !== 'string') {
        return false;
    }
    if (FILE_URI_MATCH.test(redirectUrl) ||
        WHITESPACE_CHARACTER.test(redirectUrl)) {
        return false;
    }
    let url;
    try {
        url = new URL(redirectUrl, domain);
    }
    catch (error) {
        return false;
    }
    if (INVALID_RELATIVE_URL.test(url.pathname)) {
        return false;
    }
    if (!VALID_PROTOCOLS.includes(url.protocol)) {
        return false;
    }
    if (requireSSL && url.protocol !== 'https:') {
        return false;
    }
    return true;
}
function sanitizeRedirectUrl(domain, redirectUrl, options = {}) {
    if (isSafe(domain, redirectUrl, options.requireSSL)) {
        return new URL(redirectUrl, domain);
    }
    else if (options.throwOnInvalid === false) {
        return undefined;
    }
    else {
        throw new shopifyApi.ShopifyError('Invalid URL. Refusing to redirect');
    }
}

exports.sanitizeRedirectUrl = sanitizeRedirectUrl;
//# sourceMappingURL=validate-redirect-url.js.map
