'use strict';

var createAdminApiContext = require('./create-admin-api-context.js');

async function triggerAfterAuthHook(params, session, request, authStrategy) {
    const { config, logger } = params;
    if (config.hooks.afterAuth) {
        logger.info('Running afterAuth hook', { shop: session.shop });
        const admin = createAdminApiContext.createAdminApiContext(session, params, authStrategy.handleClientError(request));
        await config.hooks.afterAuth({
            session,
            admin,
        });
    }
}

exports.triggerAfterAuthHook = triggerAfterAuthHook;
//# sourceMappingURL=trigger-after-auth-hook.js.map
