'use strict';

var appBridgeUrl = require('../../helpers/app-bridge-url.js');
var addResponseHeaders = require('../../helpers/add-response-headers.js');
var validateRedirectUrl = require('./validate-redirect-url.js');

function renderAppBridge({ config }, request, redirectTo) {
    let redirectToScript = '';
    if (redirectTo) {
        const destination = validateRedirectUrl.sanitizeRedirectUrl(config.appUrl, redirectTo.url);
        const target = redirectTo.target ?? '_top';
        redirectToScript = `<script>window.open(${JSON.stringify(destination.toString())}, ${JSON.stringify(target)})</script>`;
    }
    const responseHeaders = new Headers({
        'content-type': 'text/html;charset=utf-8',
    });
    addResponseHeaders.addDocumentResponseHeaders(responseHeaders, config.isEmbeddedApp, new URL(request.url).searchParams.get('shop'));
    throw new Response(`
      <script data-api-key="${config.apiKey}" src="${appBridgeUrl.appBridgeUrl()}"></script>
      ${redirectToScript}
    `, { headers: responseHeaders });
}

exports.renderAppBridge = renderAppBridge;
//# sourceMappingURL=render-app-bridge.js.map
