'use strict';

var shopifyApi = require('@shopify/shopify-api');
require('@remix-run/server-runtime');
var redirectToAuthPage = require('../helpers/redirect-to-auth-page.js');
var invalidateAccessToken = require('../../helpers/invalidate-access-token.js');
require('isbot');
require('../../../types.js');
var helpers = require('./helpers.js');

function requestBillingFactory(params, request, session) {
    return async function requestBilling({ plan, isTest, returnUrl, ...overrides }) {
        const { api, logger } = params;
        logger.info('Requesting billing', {
            shop: session.shop,
            plan,
            isTest,
            returnUrl,
        });
        let result;
        try {
            result = await api.billing.request({
                plan: plan,
                session,
                isTest,
                returnUrl,
                returnObject: true,
                ...overrides,
            });
        }
        catch (error) {
            if (error instanceof shopifyApi.HttpResponseError && error.response.code === 401) {
                logger.debug('API token was invalid, redirecting to OAuth', {
                    shop: session.shop,
                });
                await invalidateAccessToken.invalidateAccessToken(params, session);
                throw await redirectToAuthPage.redirectToAuthPage(params, request, session.shop);
            }
            else {
                throw error;
            }
        }
        throw helpers.redirectOutOfApp(params, request, result.confirmationUrl, session.shop);
    };
}

exports.requestBillingFactory = requestBillingFactory;
//# sourceMappingURL=request.js.map
