'use strict';

var jsxRuntime = require('react/jsx-runtime');
var polaris = require('@shopify/polaris');
var englishI18n = require('@shopify/polaris/locales/en.json');
var _const = require('../../const.js');
var RemixPolarisLink = require('../RemixPolarisLink.js');

/**
 * Sets up the Polaris `AppProvider` and injects the App Bridge script.
 *
 * This component extends the [`AppProvider`](https://polaris.shopify.com/components/utilities/app-provider) component
 * from Polaris, and accepts all of its props except for `linkComponent`, which is overridden to use the Remix `Link`
 * component.
 *
 * {@link https://polaris.shopify.com/components/utilities/app-provider}
 * {@link https://shopify.dev/tools/app-bridge}
 *
 * @example
 * <caption>Set up AppProvider.</caption>
 * <description>Wrap your app in the `AppProvider` component and pass in your API key.</description>
 * ```ts
 * // /app/routes/**\/*.ts
 * import {authenticate} from '~/shopify.server';
 * import {AppProvider} from '@shopify/shopify-app-remix/react';
 *
 * export async function loader({ request }) {
 *   await authenticate.admin(request);
 *
 *   return json({ apiKey: process.env.SHOPIFY_API_KEY });
 * }
 *
 * export default function App() {
 *   const { apiKey } = useLoaderData();
 *
 *   return (
 *     <AppProvider isEmbeddedApp apiKey={apiKey}>
 *       <Outlet />
 *     </AppProvider>
 *   );
 * }
 * ```
 *
 * @example
 * <caption>Localize Polaris components.</caption>
 * <description>Pass in a different locale for Polaris to translate its components.</description>
 * ```ts
 * // /app/routes/**\/*.ts
 * import {authenticate} from '~/shopify.server';
 * import {AppProvider} from '@shopify/shopify-app-remix/react';
 *
 * export async function loader({ request }) {
 *   await authenticate.admin(request);
 *
 *   return json({
 *     apiKey: process.env.SHOPIFY_API_KEY,
 *     polarisTranslations: require("@shopify/polaris/locales/fr.json"),
 *   });
 * }
 *
 * export default function App() {
 *   const { apiKey, polarisTranslations } = useLoaderData();
 *
 *   return (
 *     <AppProvider apiKey={apiKey} i18n={polarisTranslations}>
 *       <Outlet />
 *     </AppProvider>
 *   );
 * }
 * ```
 */
function AppProvider(props) {
    const { children, apiKey, i18n, isEmbeddedApp = true, __APP_BRIDGE_URL = _const.APP_BRIDGE_URL, ...polarisProps } = props;
    return (jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [isEmbeddedApp && jsxRuntime.jsx("script", { src: __APP_BRIDGE_URL, "data-api-key": apiKey }), jsxRuntime.jsx(polaris.AppProvider, { ...polarisProps, linkComponent: RemixPolarisLink.RemixPolarisLink, i18n: i18n || englishI18n, children: children })] }));
}

exports.AppProvider = AppProvider;
//# sourceMappingURL=AppProvider.js.map
