import '../crypto/crypto.mjs';
import '../crypto/types.mjs';

function isOK(resp) {
    // https://fetch.spec.whatwg.org/#ok-status
    return resp.statusCode >= 200 && resp.statusCode <= 299;
}
// We ignore mutable export linting errors because we explicitly want these abstract functions to be overwritten.
// eslint-disable-next-line import/no-mutable-exports
let abstractFetch = () => {
    throw new Error("Missing adapter implementation for 'abstractFetch' - make sure to import the appropriate adapter for your platform");
};
function setAbstractFetchFunc(func) {
    abstractFetch = func;
}
// eslint-disable-next-line import/no-mutable-exports
let abstractConvertRequest = () => {
    throw new Error("Missing adapter implementation for 'abstractConvertRequest' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertRequestFunc(func) {
    abstractConvertRequest = func;
}
// By default we just return an empty NormalizedResponse because not all adapters will need to convert an incoming response
// eslint-disable-next-line import/no-mutable-exports
let abstractConvertIncomingResponse = () => Promise.resolve({});
function setAbstractConvertIncomingResponseFunc(func) {
    abstractConvertIncomingResponse = func;
}
// eslint-disable-next-line import/no-mutable-exports
let abstractConvertResponse = () => {
    throw new Error("Missing adapter implementation for 'abstractConvertResponse' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertResponseFunc(func) {
    abstractConvertResponse = func;
}
// eslint-disable-next-line import/no-mutable-exports
let abstractConvertHeaders = () => {
    throw new Error("Missing adapter implementation for 'abstractConvertHeaders' - make sure to import the appropriate adapter for your platform");
};
function setAbstractConvertHeadersFunc(func) {
    abstractConvertHeaders = func;
}

export { abstractConvertHeaders, abstractConvertIncomingResponse, abstractConvertRequest, abstractConvertResponse, abstractFetch, isOK, setAbstractConvertHeadersFunc, setAbstractConvertIncomingResponseFunc, setAbstractConvertRequestFunc, setAbstractConvertResponseFunc, setAbstractFetchFunc };
//# sourceMappingURL=index.mjs.map
