import { logger } from '../logger/index.mjs';
import { LogSeverity } from '../types.mjs';
import { abstractFetch } from '../../runtime/http/index.mjs';
import '../../runtime/crypto/types.mjs';
import '../../runtime/crypto/crypto.mjs';

function fetchRequestFactory(config) {
    return async function fetchRequest(url, options) {
        const log = logger(config);
        const doLog = config.logger.httpRequests && config.logger.level === LogSeverity.Debug;
        if (doLog) {
            log.debug('Making HTTP request', {
                method: options?.method || 'GET',
                url,
                ...(options?.body && { body: options?.body }),
            });
        }
        const response = await abstractFetch(url, options);
        if (doLog) {
            log.debug('HTTP request completed', {
                method: options?.method || 'GET',
                url,
                status: response.status,
            });
        }
        return response;
    };
}

export { fetchRequestFactory };
//# sourceMappingURL=fetch-request.mjs.map
