import { loadRestResources } from '../rest/load-rest-resources.mjs';
import { abstractRuntimeString } from '../runtime/platform/runtime-string.mjs';
import { logDisabledFutureFlags } from '../future/flags.mjs';
import { validateConfig } from './config.mjs';
import { clientClasses } from './clients/index.mjs';
import { shopifyAuth } from './auth/index.mjs';
import { shopifySession } from './session/index.mjs';
import { shopifyUtils } from './utils/index.mjs';
import { shopifyWebhooks } from './webhooks/index.mjs';
import { shopifyBilling } from './billing/index.mjs';
import { logger } from './logger/index.mjs';
import { SHOPIFY_API_LIBRARY_VERSION } from './version.mjs';
import { restClientClass } from './clients/admin/rest/client.mjs';
export { RestClient } from './clients/admin/rest/client.mjs';
import { shopifyFlow } from './flow/index.mjs';
import { fulfillmentService } from './fulfillment-service/index.mjs';
export { BillingError, BotActivityDetected, CookieNotFound, FeatureDeprecatedError, GraphqlQueryError, HttpInternalError, HttpMaxRetriesError, HttpRequestError, HttpResponseError, HttpRetriableError, HttpThrottlingError, InvalidDeliveryMethodError, InvalidHmacError, InvalidHostError, InvalidJwtError, InvalidOAuthError, InvalidRequestError, InvalidSession, InvalidShopError, InvalidWebhookError, MissingJwtTokenError, MissingRequiredArgument, MissingWebhookCallbackError, PrivateAppError, RestResourceError, SafeCompareError, SessionStorageError, ShopifyError, UnsupportedClientType } from './error.mjs';
export { Session } from './session/session.mjs';
export { ApiVersion, BillingInterval, BillingReplacementBehavior, ClientType, LATEST_API_VERSION, LIBRARY_NAME, LogSeverity, RELEASE_CANDIDATE_API_VERSION, ShopifyHeader, privacyTopics } from './types.mjs';
export { SESSION_COOKIE_NAME, STATE_COOKIE_NAME } from './auth/oauth/types.mjs';
export { AuthScopes } from './auth/scopes/index.mjs';
export { RequestedTokenType } from './auth/oauth/token-exchange.mjs';
export { APP_SUBSCRIPTION_FRAGMENT } from './billing/types.mjs';
export { DataType } from './clients/types.mjs';
export { DeliveryMethod, WebhookOperation, WebhookValidationErrorReason } from './webhooks/types.mjs';
export { HmacValidationType, ValidationErrorReason } from './utils/types.mjs';
export { GraphqlClient } from './clients/admin/graphql/client.mjs';

function shopifyApi({ future, restResources, ...config }) {
    const libConfig = { ...config, future, restResources };
    const validatedConfig = validateConfig(libConfig);
    const shopify = {
        config: validatedConfig,
        clients: clientClasses(validatedConfig),
        auth: shopifyAuth(validatedConfig),
        session: shopifySession(validatedConfig),
        utils: shopifyUtils(validatedConfig),
        webhooks: shopifyWebhooks(validatedConfig),
        billing: shopifyBilling(validatedConfig),
        flow: shopifyFlow(validatedConfig),
        fulfillmentService: fulfillmentService(validatedConfig),
        logger: logger(validatedConfig),
        rest: {},
    };
    if (restResources) {
        shopify.rest = loadRestResources({
            resources: restResources,
            config: validatedConfig,
            RestClient: restClientClass({ config: validatedConfig }),
        });
    }
    shopify.logger
        .info(`version ${SHOPIFY_API_LIBRARY_VERSION}, environment ${abstractRuntimeString()}`)
        .catch((err) => console.log(err));
    logDisabledFutureFlags(validatedConfig, shopify.logger);
    return shopify;
}

export { shopifyApi };
//# sourceMappingURL=index.mjs.map
