import '../../../runtime/crypto/types.mjs';
import { crypto as cryptoVar } from '../../../runtime/crypto/crypto.mjs';

function nonce() {
    const length = 15;
    const bytes = cryptoVar.getRandomValues(new Uint8Array(length));
    const nonce = bytes
        .map((byte) => {
        return byte % 10;
    })
        .join('');
    return nonce;
}

export { nonce };
//# sourceMappingURL=nonce.mjs.map
