import '../../runtime/crypto/crypto.mjs';
import '../../runtime/crypto/types.mjs';
import { addHeader, flatHeaders } from '../../runtime/http/headers.mjs';

async function webApiConvertRequest(adapterArgs) {
    const request = adapterArgs.rawRequest;
    const headers = {};
    for (const [key, value] of request.headers.entries()) {
        addHeader(headers, key, value);
    }
    return {
        headers,
        method: request.method ?? 'GET',
        url: new URL(request.url).toString(),
    };
}
async function webApiConvertHeaders(headers, _adapterArgs) {
    const remixHeaders = new Headers();
    flatHeaders(headers ?? {}).forEach(([key, value]) => remixHeaders.append(key, value));
    return Promise.resolve(remixHeaders);
}
async function webApiConvertResponse(resp, adapterArgs) {
    return new Response(resp.body, {
        status: resp.statusCode,
        statusText: resp.statusText,
        headers: await webApiConvertHeaders(resp.headers ?? {}),
    });
}
function webApiRuntimeString() {
    return 'Web API';
}

export { webApiConvertHeaders, webApiConvertRequest, webApiConvertResponse, webApiRuntimeString };
//# sourceMappingURL=adapter.mjs.map
