import { Request, Headers, Response } from 'node-fetch';
import '../../runtime/crypto/crypto.mjs';
import '../../runtime/crypto/types.mjs';
import { canonicalizeHeaders } from '../../runtime/http/headers.mjs';
import { mockTestRequests } from './mock_test_requests.mjs';

async function mockConvertRequest(adapterArgs) {
    return Promise.resolve(adapterArgs.rawRequest);
}
async function mockConvertResponse(response, _adapterArgs) {
    return Promise.resolve(response);
}
async function mockConvertHeaders(headers, _adapterArgs) {
    return Promise.resolve(headers);
}
const mockFetch = async (url, init) => {
    const mockInit = init;
    const request = new Request(url, mockInit);
    const headers = Object.fromEntries(new Headers(mockInit?.headers).entries());
    mockTestRequests.requestList.push({
        url: request.url,
        method: request.method,
        headers: canonicalizeHeaders(headers),
        body: await request.text(),
    });
    const next = mockTestRequests.responseList.shift();
    if (!next) {
        throw new Error(`Missing mock for ${request.method} to ${url}, have you queued all required responses?`);
    }
    if (next instanceof Error) {
        throw next;
    }
    const responseHeaders = new Headers();
    Object.entries(next.headers ?? {}).forEach(([key, value]) => {
        responseHeaders.set(key, typeof value === 'string' ? value : value.join(', '));
    });
    return new Response(next.body, {
        status: next.statusCode,
        statusText: next.statusText,
        headers: responseHeaders,
    });
};
function mockRuntimeString() {
    return 'Mock adapter';
}

export { mockConvertHeaders, mockConvertRequest, mockConvertResponse, mockFetch, mockRuntimeString };
//# sourceMappingURL=adapter.mjs.map
