'use strict';

var base = require('../../base.js');
var types = require('../../../lib/types.js');
var fulfillment = require('./fulfillment.js');

/***********************************************************************************************************************
* This file is auto-generated. If you have an issue, please create a GitHub issue.                                     *
***********************************************************************************************************************/
class DisputeEvidence extends base.Base {
    static apiVersion = types.ApiVersion.July25;
    static hasOne = {};
    static hasMany = {
        "fulfillments": fulfillment.Fulfillment
    };
    static paths = [
        { "http_method": "get", "operation": "get", "ids": ["dispute_id"], "path": "shopify_payments/disputes/<dispute_id>/dispute_evidences.json" },
        { "http_method": "put", "operation": "put", "ids": ["dispute_id"], "path": "shopify_payments/disputes/<dispute_id>/dispute_evidences.json" }
    ];
    static primaryKey = "dispute_id";
    static resourceNames = [
        {
            "singular": "dispute_evidence",
            "plural": "dispute_evidences"
        }
    ];
    static async find({ session, dispute_id }) {
        const result = await this.baseFind({
            session: session,
            urlIds: { "dispute_id": dispute_id },
            params: {},
        });
        return result.data ? result.data[0] : null;
    }
    access_activity_log;
    billing_address;
    cancellation_policy_disclosure;
    cancellation_rebuttal;
    created_at;
    customer_email_address;
    customer_first_name;
    customer_last_name;
    dispute_evidence_files;
    fulfillments;
    id;
    payments_dispute_id;
    product_description;
    refund_policy_disclosure;
    refund_refusal_explanation;
    shipping_address;
    submitted;
    uncategorized_text;
    updated_on;
}

exports.DisputeEvidence = DisputeEvidence;
//# sourceMappingURL=dispute_evidence.js.map
