import React from 'react';
import { getResponsiveProps, sanitizeCustomProperties } from '../../utilities/css.js';
import styles from './Bleed.css.js';

const Bleed = ({
  marginInline,
  marginBlock,
  marginBlockStart,
  marginBlockEnd,
  marginInlineStart,
  marginInlineEnd,
  children
}) => {
  const getNegativeMargins = direction => {
    const xAxis = ['marginInlineStart', 'marginInlineEnd'];
    const yAxis = ['marginBlockStart', 'marginBlockEnd'];
    const directionValues = {
      marginBlockStart,
      marginBlockEnd,
      marginInlineStart,
      marginInlineEnd,
      marginInline,
      marginBlock
    };
    if (directionValues[direction]) {
      return directionValues[direction];
    } else if (xAxis.includes(direction) && marginInline) {
      return directionValues.marginInline;
    } else if (yAxis.includes(direction) && marginBlock) {
      return directionValues.marginBlock;
    }
  };
  const negativeMarginBlockStart = getNegativeMargins('marginBlockStart');
  const negativeMarginBlockEnd = getNegativeMargins('marginBlockEnd');
  const negativeMarginInlineStart = getNegativeMargins('marginInlineStart');
  const negativeMarginInlineEnd = getNegativeMargins('marginInlineEnd');
  const style = {
    ...getResponsiveProps('bleed', 'margin-block-start', 'space', negativeMarginBlockStart),
    ...getResponsiveProps('bleed', 'margin-block-end', 'space', negativeMarginBlockEnd),
    ...getResponsiveProps('bleed', 'margin-inline-start', 'space', negativeMarginInlineStart),
    ...getResponsiveProps('bleed', 'margin-inline-end', 'space', negativeMarginInlineEnd)
  };
  return /*#__PURE__*/React.createElement("div", {
    className: styles.Bleed,
    style: sanitizeCustomProperties(style)
  }, children);
};

export { Bleed };
