'use strict';

var addPlugin = require('@graphql-codegen/add');
var typescriptPlugin = require('@graphql-codegen/typescript');
var typescriptOperationPlugin = require('@graphql-codegen/typescript-operations');
var sources_js = require('./sources.cjs');
var plugin_js = require('./plugin.cjs');

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var addPlugin__namespace = /*#__PURE__*/_interopNamespace(addPlugin);
var typescriptPlugin__namespace = /*#__PURE__*/_interopNamespace(typescriptPlugin);
var typescriptOperationPlugin__namespace = /*#__PURE__*/_interopNamespace(typescriptOperationPlugin);

const ERROR_PREFIX = "[@shopify/graphql-codegen]";
const preset = {
  [Symbol.for("name")]: "@shopify/graphql-codegen",
  buildGeneratesSection: (options) => {
    if (!options.baseOutputDir.endsWith(".ts")) {
      throw new Error(
        ERROR_PREFIX + " target output should be a .ts or a .d.ts file."
      );
    }
    if (options.plugins?.length > 0 && Object.keys(options.plugins).some((p) => p.startsWith("typescript"))) {
      throw new Error(
        ERROR_PREFIX + " providing additional typescript-based `plugins` leads to duplicated generated types"
      );
    }
    const isDts = options.baseOutputDir.endsWith(".d.ts");
    const sourcesWithOperations = sources_js.processSources(options.documents);
    const sources = sourcesWithOperations.map(({ source }) => source);
    const namespacedImportName = options.presetConfig.importTypes?.namespace;
    const importTypesFrom = options.presetConfig.importTypes?.from;
    const importTypes = !!namespacedImportName && !!importTypesFrom;
    const interfaceExtensionCode = options.presetConfig.interfaceExtension({
      queryType: plugin_js.GENERATED_QUERY_INTERFACE_NAME,
      mutationType: plugin_js.GENERATED_MUTATION_INTERFACE_NAME
    });
    const pluginMap = {
      ...options.pluginMap,
      [`add`]: addPlugin__namespace,
      [`typescript`]: typescriptPlugin__namespace,
      [`typescript-operations`]: typescriptOperationPlugin__namespace,
      [`gen-dts`]: { plugin: plugin_js.plugin }
    };
    const plugins = [
      // 1. Disable eslint for the generated file
      {
        [`add`]: {
          content: `/* eslint-disable eslint-comments/disable-enable-pair */
/* eslint-disable eslint-comments/no-unlimited-disable */
/* eslint-disable */`
        }
      },
      // 2. Import all the generated API types or generate all the types from the schema.
      importTypes ? {
        [`add`]: {
          content: `import${isDts ? " type " : " "}* as ${namespacedImportName} from '${importTypesFrom}';
`
        }
      } : {
        [`typescript`]: {
          enumsAsTypes: isDts,
          useTypeImports: isDts,
          useImplementingTypes: true
        }
      },
      // 3. Generate the operations (i.e. queries, mutations, and fragments types)
      {
        [`typescript-operations`]: {
          useTypeImports: isDts,
          // Use `import type` instead of `import`
          preResolveTypes: false,
          // Use Pick<...> instead of primitives
          mergeFragmentTypes: true,
          // Merge equal fragment interfaces. Avoids adding `| {}` to Metaobject
          skipTypename: options.presetConfig.skipTypenameInOperations ?? true,
          // Skip __typename fields
          namespacedImportName: importTypes ? namespacedImportName : void 0
        }
      },
      // 4.  Augment query/mutation interfaces with the generated operations
      { [`gen-dts`]: { sourcesWithOperations, interfaceExtensionCode } },
      // 5. Custom plugins from the user
      ...options.plugins
    ];
    return [
      {
        filename: options.baseOutputDir,
        plugins,
        pluginMap,
        schema: options.schema,
        config: {
          // For the TS plugin:
          defaultScalarType: "unknown",
          // Allow overwriting defaults:
          ...options.config
        },
        documents: sources,
        documentTransforms: options.documentTransforms
      }
    ];
  }
};

exports.preset = preset;
//# sourceMappingURL=out.js.map
//# sourceMappingURL=preset.cjs.map