import { Types } from '@graphql-codegen/plugin-helpers';
import { CodegenConfig } from '@graphql-codegen/cli';
import { IGraphQLProject } from 'graphql-config';
export { pluckConfig } from '@shopify/graphql-codegen';

declare enum ApiType {
    Admin = "Admin",
    Storefront = "Storefront",
    Customer = "Customer"
}
interface ShopifyApiPresetConfig {
    apiType: ApiType;
    module?: string;
}
interface ShopifyApiProjectOptions {
    apiType: ApiType;
    apiVersion?: string;
    outputDir?: string;
    documents?: string[];
    module?: string;
    declarations?: boolean;
    apiKey?: string;
}
type ShopifyApiTypesOptions = ShopifyApiProjectOptions;

declare const preset: Types.OutputPreset<ShopifyApiPresetConfig>;

declare const shopifyApiTypes: ({ apiType, apiVersion, module, outputDir, documents, declarations, apiKey, }: ShopifyApiTypesOptions) => CodegenConfig["generates"];

declare const shopifyApiProject: ({ apiType, apiVersion, module, outputDir, documents, declarations, apiKey, }: ShopifyApiProjectOptions) => IGraphQLProject;

export { ApiType, preset, shopifyApiProject, shopifyApiTypes };
export type { ShopifyApiPresetConfig, ShopifyApiProjectOptions, ShopifyApiTypesOptions };
