import fs from 'fs';
import { preset } from './preset.mjs';
import { getSchemaData } from './helpers/get-schema-data.mjs';
import { getOutputFiles } from './helpers/get-output-files.mjs';

const shopifyApiTypes = ({ apiType, apiVersion, module, outputDir = '.', documents = ['**/*.{ts,tsx}', '!**/node_modules'], declarations = true, apiKey, }) => {
    const { schema, schemaFile } = getSchemaData(outputDir, apiType, {
        apiVersion,
        apiKey,
    });
    const { typesFile, queryTypesFile } = getOutputFiles(apiType, declarations);
    const schemaFileExists = fs.existsSync(`${schemaFile}`);
    return {
        ...(schemaFileExists
            ? {}
            : {
                [schemaFile]: {
                    schema,
                    plugins: ['introspection'],
                    config: { minify: true },
                },
            }),
        [`${outputDir}/${typesFile}`]: {
            schema: schemaFileExists ? schemaFile : schema,
            plugins: ['typescript'],
        },
        [`${outputDir}/${queryTypesFile}`]: {
            schema: schemaFileExists ? schemaFile : schema,
            preset,
            documents,
            presetConfig: { apiType, module },
        },
    };
};

export { shopifyApiTypes };
//# sourceMappingURL=api-types.mjs.map
