'use strict';

var fs = require('fs');
var preset = require('./preset.js');
var getSchemaData = require('./helpers/get-schema-data.js');
var getOutputFiles = require('./helpers/get-output-files.js');

const shopifyApiTypes = ({ apiType, apiVersion, module, outputDir = '.', documents = ['**/*.{ts,tsx}', '!**/node_modules'], declarations = true, apiKey, }) => {
    const { schema, schemaFile } = getSchemaData.getSchemaData(outputDir, apiType, {
        apiVersion,
        apiKey,
    });
    const { typesFile, queryTypesFile } = getOutputFiles.getOutputFiles(apiType, declarations);
    const schemaFileExists = fs.existsSync(`${schemaFile}`);
    return {
        ...(schemaFileExists
            ? {}
            : {
                [schemaFile]: {
                    schema,
                    plugins: ['introspection'],
                    config: { minify: true },
                },
            }),
        [`${outputDir}/${typesFile}`]: {
            schema: schemaFileExists ? schemaFile : schema,
            plugins: ['typescript'],
        },
        [`${outputDir}/${queryTypesFile}`]: {
            schema: schemaFileExists ? schemaFile : schema,
            preset: preset.preset,
            documents,
            presetConfig: { apiType, module },
        },
    };
};

exports.shopifyApiTypes = shopifyApiTypes;
//# sourceMappingURL=api-types.js.map
