'use strict';

var fs = require('fs');
var graphqlCodegen = require('@shopify/graphql-codegen');
var apiTypes = require('./api-types.js');
var getSchemaData = require('./helpers/get-schema-data.js');

const shopifyApiProject = ({ apiType, apiVersion, module, outputDir = '.', documents = ['**/*.{ts,tsx}', '!node_modules'], declarations = true, apiKey, }) => {
    const { schema, schemaFile } = getSchemaData.getSchemaData(outputDir, apiType, {
        apiVersion,
        apiKey,
    });
    const schemaFileExists = fs.existsSync(`${schemaFile}`);
    return {
        schema: schemaFileExists ? schemaFile : schema,
        documents,
        extensions: {
            codegen: {
                pluckConfig: graphqlCodegen.pluckConfig,
                generates: apiTypes.shopifyApiTypes({
                    apiType,
                    apiVersion,
                    apiKey,
                    outputDir,
                    documents,
                    module,
                    declarations,
                }),
            },
        },
    };
};

exports.shopifyApiProject = shopifyApiProject;
//# sourceMappingURL=api-project.js.map
