import { CLIENT } from './constants.mjs';

function validateRequiredAccessToken(accessToken) {
    if (!accessToken) {
        throw new Error(`${CLIENT}: an access token must be provided`);
    }
}
function validateServerSideUsage(isTesting = false) {
    if (typeof window !== 'undefined' && !isTesting) {
        throw new Error(`${CLIENT}: this client should not be used in the browser`);
    }
}

export { validateRequiredAccessToken, validateServerSideUsage };
//# sourceMappingURL=validations.mjs.map
