'use strict';

var constants = require('./constants.js');

function validateRequiredAccessToken(accessToken) {
    if (!accessToken) {
        throw new Error(`${constants.CLIENT}: an access token must be provided`);
    }
}
function validateServerSideUsage(isTesting = false) {
    if (typeof window !== 'undefined' && !isTesting) {
        throw new Error(`${constants.CLIENT}: this client should not be used in the browser`);
    }
}

exports.validateRequiredAccessToken = validateRequiredAccessToken;
exports.validateServerSideUsage = validateServerSideUsage;
//# sourceMappingURL=validations.js.map
