/**
 * @remix-run/fs-routes v2.17.0
 *
 * Copyright (c) Remix Software Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE.md file in the root directory of this source tree.
 *
 * @license MIT
 */
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var fs = require('node:fs');
var path = require('node:path');
var dev = require('@remix-run/dev');
var routeConfig = require('@remix-run/route-config');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var fs__default = /*#__PURE__*/_interopDefaultLegacy(fs);
var path__default = /*#__PURE__*/_interopDefaultLegacy(path);

/**
 * Creates route config from the file system that matches [Remix's default file
 * conventions](https://remix.run/docs/en/v2/file-conventions/routes), for
 * use within `routes.ts`.
 */
async function flatRoutes(options = {}) {
  let {
    ignoredRouteFiles = [],
    rootDirectory: userRootDirectory = "routes"
  } = options;
  let appDirectory = routeConfig.getAppDirectory();
  let rootDirectory = path__default["default"].resolve(appDirectory, userRootDirectory);
  let relativeRootDirectory = path__default["default"].relative(appDirectory, rootDirectory);
  let prefix = normalizeSlashes(relativeRootDirectory);
  let routes = fs__default["default"].existsSync(rootDirectory) ? dev.UNSAFE_flatRoutes(appDirectory, ignoredRouteFiles, prefix) : {};
  return dev.UNSAFE_routeManifestToRouteConfig(routes);
}
function normalizeSlashes(file) {
  return file.split(path__default["default"].win32.sep).join("/");
}

exports.flatRoutes = flatRoutes;
