import { API_BASE_URL, API_TOKEN, ENDPOINTS, buildApiUrl } from './apiConfig';
/**
 * Fetch product list from GetGabs API
 * @param {Object} options - API request options
 * @param {number} options.page - Page number (default: 1)
 * @param {number} options.perPageData - Items per page (default: 20)
 * @returns {Promise<Object>} API response with product list data
 */
export const fetchProductList = async (options = {}) => {
  const { 
    page = 1,
    perPageData = 20
  } = options;

  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.PRODUCT.BASE}/${ENDPOINTS.PRODUCT.GET_PRODUCT_LIST}`));
    url.searchParams.append('page', page.toString());
    url.searchParams.append('perPageData', perPageData.toString());
    url.searchParams.append('token', API_TOKEN);

    const response = await fetch(url.toString(), {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Error fetching product list:', error);
    throw error;
  }
};

export const fetchallCategoryList = async (options = {}) => {
  const { 
    page = 1,
    perPageData = 200,
  } = options;

  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.CATEGORY.BASE}/${ENDPOINTS.CATEGORY.GET_CATEGORY_LIST}`));
    url.searchParams.append('page', page.toString());
    url.searchParams.append('perPageData', perPageData.toString());
    url.searchParams.append('token', API_TOKEN);

    const response = await fetch(url.toString(), {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Error fetching category list:', error);
    throw error;
  }
};