import { API_TOKEN } from './apiConfig';

export const getPricingPlanLink = async (plan_id) => { 
  const response = await fetch(`https://app.getgabs.com/partners/shopify/plan/purchase`, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'Authorization': `Bearer ${API_TOKEN}`
    },
    body: JSON.stringify({
      plan_id: plan_id,
      token: API_TOKEN
    })
  });
  if (!response.ok) throw new Error('Failed to fetch PRICING LINK');
  const data = await response.json();
  console.log( "PRICING LINK", data);
  return data;
};