import { accountDetails } from "./apiConfig";

// let planDetails = {
//   planPurchaseStatus: true,
//   planTaken: "",
//   isConnected: true,
// };
let planDetails = {
  planPurchaseStatus: accountDetails.isplanpurchased,
  planTaken: accountDetails.planName,
  isConnected: accountDetails.isAccountConnected,
};


export function isPlanPurchased() {
  return planDetails.planPurchaseStatus;
}

export function isAccountConnected() {
  return planDetails.isConnected;
}

export function getPlanName() {
  return planDetails.planTaken;
}

export function getFormattedPlanName() {
  const planName = planDetails.planTaken || "";
  return planName ? planName.charAt(0).toUpperCase() + planName.slice(1) : "";
}


export function setPlanPurchaseStatus(status) {
  planDetails.planPurchaseStatus = status;
}

export function setConnectionStatus(status) {
  planDetails.isConnected = status;
}

export function setPlanName(planName) {
  planDetails.planTaken = planName;
}

export function updatePlanDetails(status, planName, isConnected) {
  planDetails.planPurchaseStatus = status;
  planDetails.planTaken = planName;
  if (typeof isConnected !== "undefined") {
    planDetails.isConnected = isConnected;
  }
}


const allowedRoutes = [
  "/app",
  "/app/",
  "/app/pricing-plan",
];


const connectionRestrictedRoutes = [
  "/app/auto-triggers/create-abandoned-cart",
  "/app/auto-triggers/create-order-confirmation",
  "/apps/getgabsnewwabadesign/app/auto-triggers/create-auto-reply",
];
const connectionRestrictedPatterns = [
  /^\/app\/create-template\//,
  /^\/app\/broadcast\//,
];


const planRestrictedRoutes = [
  "/app/auto-triggers/create-abandoned-cart",
  "/app/auto-triggers/create-order-confirmation",
  "/apps/getgabsnewwabadesign/app/auto-triggers/create-auto-reply",
];
const planRestrictedPatterns = [
  /^\/app\/create-template\//,
  /^\/app\/broadcast\//,
];


const matchesRestricted = (pathname, routes, patterns) =>
  routes.includes(pathname) || patterns.some((pattern) => pattern.test(pathname));


export function isRouteAccessible(pathname) {
  const connected = isAccountConnected();
  const purchased = isPlanPurchased();

  // Always allow access to allowed routes
  if (allowedRoutes.includes(pathname)) {
    return true;
  }

  // Check connection restrictions
  if (!connected && matchesRestricted(pathname, connectionRestrictedRoutes, connectionRestrictedPatterns)) {
    return false;
  }

  // Check plan restrictions for connected users
  if (connected && !purchased && matchesRestricted(pathname, planRestrictedRoutes, planRestrictedPatterns)) {
    return false;
  }

  return true;
}


export function getRedirectUrl(pathname) {
  const connected = isAccountConnected();
  const purchased = isPlanPurchased();


  if (!connected && matchesRestricted(pathname, connectionRestrictedRoutes, connectionRestrictedPatterns)) {
    return "/app";
  }


  if (connected && !purchased && matchesRestricted(pathname, planRestrictedRoutes, planRestrictedPatterns)) {
    return "/app/pricing-plan";
  }


  return "/app";
}


export async function fetchPlanStatus() {
  try {
    return planDetails.planPurchaseStatus;
  } catch (error) {
    console.error("Error fetching plan status:", error);
    return false;
  }
}
