import { API_BASE_URL, API_TOKEN, ENDPOINTS, buildApiUrl } from './apiConfig';
/**
 * Fetch abandoned cart list from GetGabs API
 * @param {Object} options - API request options
 * @param {number} options.page - Page number (default: 1)
 * @param {number} options.perPageData - Items per page (default: 20)
 * @returns {Promise<Object>} API response with order confirmation list data
 */
export const fetchOrderConfirmationTriggerList = async (options = {}) => {
  const { 
    page = 1,
    perPageData = 20,
    TriggerCategory=2,
  } = options;

  try {
    const url = new URL(buildApiUrl(`${ENDPOINTS.ORDER_CONFIRMATION.BASE}/${ENDPOINTS.ORDER_CONFIRMATION.GET_ORDER_CONFIRMATION_LIST}`));
    url.searchParams.append('page', page.toString());
    url.searchParams.append('perPageData', perPageData.toString());
    url.searchParams.append('TriggerCategory', TriggerCategory.toString());
    url.searchParams.append('token', API_TOKEN);

    const response = await fetch(url.toString(), {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Error fetching order confirmation list:', error);
    throw error;
  }
};