import { API_BASE_URL, API_TOKEN, ENDPOINTS, buildApiUrl } from './apiConfig';

/** 
 * get whatsapp profile json data from getgabs
 * @returns {Object} Whatsapp profile json data
 */
export const getWhatsappProfileJson = async () => { 
    const response = await fetch(`https://app.getgabs.com/partners/settings/whatsappprofile/fetchprofile?JsonData=2`, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
        'Authorization': `Bearer ${API_TOKEN}`
      }
    });
    if (!response.ok) throw new Error('Failed to fetch template list');
    const data = await response.json();
    console.log( "whatsapp profile json", data);
    return data;
  };

  /** 
  * add single contacts under contact list
  * @returns {Object} Contact
  */
 export const updateWhatsappProfile = async (updateWhatsappProfilePayload) => { 
   try {
     const url = `https://app.getgabs.com/partners/settings/whatsappprofile/updatewpprofile`;
     const response = await fetch(url, {
       method: 'POST',
       headers: {
         'Content-Type': 'application/json',
         'Accept': 'application/json',
         'Authorization': `Bearer ${API_TOKEN}`,
         'X-Requested-With': 'XMLHttpRequest',

       },
       body: JSON.stringify(updateWhatsappProfilePayload)
     });
     const maybeJson = await response.json().catch(() => null);
 
     if (!response.ok) {
       const message = (maybeJson && (maybeJson.message || maybeJson.error)) || `HTTP ${response.status}`;
       throw new Error(message);
     }
 
     const data = maybeJson ?? {};
     const success = data?.status === true || data?.success === true || data?.status === 'success';
     if (!success) {
       throw new Error(data?.message || 'Update whatsapp profile failed');
     }
 
     console.log('update whatsapp profile', data);
     return data;
   } catch (error) {
     console.error('Error updating whatsapp profile:', error);
     throw error;
   }
 };


 /** 
 * get whatsapp profile json data from getgabs
 * @returns {Object} Whatsapp profile json data
 */
export const getChatWidgetDataJson = async () => { 
  const response = await fetch(`https://app.getgabs.com/partners/managechat/customertagmanage/chatwidget/fetchWidgetData?dataJson=1`, {
    method: 'GET',
    headers: {
      'Content-Type': 'application/json',
      'Authorization': `Bearer ${API_TOKEN}`,
    }
  });
  if (!response.ok) throw new Error('Failed to fetch chat widget data');
  const data = await response.json();
  console.log( "chat widget data", data);
  return data;
};

 /** 
  * add single contacts under contact list
  * @returns {Object} Contact
  */
 export const updateWhatappchatWidget = async (updateWhatsappchatWidgetPayload) => {   
  try {
    const url = `https://app.getgabs.com/partners/managechat/customertagmanage/chatwidget/updateWidgetData`;
    const response = await fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
        'Authorization': `Bearer ${API_TOKEN}`,
        'X-Requested-With': 'XMLHttpRequest',

      },
      body: JSON.stringify(updateWhatsappchatWidgetPayload)
    });
    const maybeJson = await response.json().catch(() => null);

    if (!response.ok) {
      const message = (maybeJson && (maybeJson.message || maybeJson.error)) || `HTTP ${response.status}`;
      throw new Error(message);
    }

    const data = maybeJson ?? {};
    const success = data?.status === true || data?.success === true || data?.status === 'success';
    if (!success) {
      throw new Error(data?.message || 'Update whatsapp chat widget failed');
    }

    console.log('update whatsapp chat widget', data);
    return data;
  } catch (error) {
    console.error('Error updating whatsapp chat widget:', error);
    throw error;
  }
};
