export const emojiCategories = {
  smileys: {
    name: 'Smileys & People',
    icon: '😀',
    emojis: [
      '😀', '😃', '😄', '😁', '😆', '😅', '🤣', '😂', '🙂', '🙃',
      '😉', '😊', '😇', '🥰', '😍', '🤩', '😘', '😗', '😚', '😙',
      '😋', '😛', '😜', '🤪', '😝', '🤑', '🤗', '🤭', '🤫', '🤔',
      '🤐', '🤨', '😐', '😑', '😶', '😏', '😒', '🙄', '😬', '🤥',
      '😔', '😪', '🤤', '😴', '😷', '🤒', '🤕', '🤢', '🤮', '🤧',
      '🥵', '🥶', '🥴', '😵', '🤯', '🤠', '🥳', '😎', '🤓', '🧐',
      '👋', '🤚', '🖐️', '✋', '🖖', '👌', '🤏', '✌️', '🤞', '🤟',
      '🤘', '🤙', '👈', '👉', '👆', '🖕', '👇', '☝️', '👍', '👎',
      '👊', '✊', '🤛', '🤜', '👏', '🙌', '👐', '🤲', '🤝', '🙏'
    ]
  },
  hearts: {
    name: 'Hearts & Love',
    icon: '❤️',
    emojis: [
      '❤️', '🧡', '💛', '💚', '💙', '💜', '🖤', '🤍', '🤎', '💔',
      '❣️', '💕', '💞', '💓', '💗', '💖', '💘', '💝', '💟', '♥️',
      '💋', '💌', '💐', '🌹', '🌷', '🌺', '🌸', '🌻', '🌼', '💒'
    ]
  },
  gestures: {
    name: 'Gestures',
    icon: '👍',
    emojis: [
      '👍', '👎', '👌', '✌️', '🤞', '🤟', '🤘', '🤙', '👈', '👉',
      '👆', '👇', '☝️', '👋', '🤚', '🖐️', '✋', '🖖', '👏', '🙌',
      '👐', '🤲', '🤝', '🙏', '✍️', '💪', '🦵', '🦶', '👂', '👃'
    ]
  },
  activities: {
    name: 'Activities & Sports',
    icon: '⚽',
    emojis: [
      '⚽', '🏀', '🏈', '⚾', '🥎', '🎾', '🏐', '🏉', '🥏', '🎱',
      '🪀', '🏓', '🏸', '🏒', '🏑', '🥍', '🏏', '🪃', '🥅', '⛳',
      '🪁', '🏹', '🎣', '🤿', '🥊', '🥋', '🎽', '🛹', '🛷', '⛸️',
      '🥌', '🎿', '⛷️', '🏂', '🪂', '🏋️', '🤼', '🤸', '⛹️', '🤺',
      '🏇', '🧘', '🏄', '🏊', '🤽', '🚣', '🧗', '🚵', '🚴', '🏆'
    ]
  },
  food: {
    name: 'Food & Drink',
    icon: '🍕',
    emojis: [
      '🍎', '🍐', '🍊', '🍋', '🍌', '🍉', '🍇', '🍓', '🫐', '🍈',
      '🍒', '🍑', '🥭', '🍍', '🥥', '🥝', '🍅', '🍆', '🥑', '🥦',
      '🥬', '🥒', '🌶️', '🫑', '🌽', '🥕', '🫒', '🧄', '🧅', '🥔',
      '🍠', '🥐', '🥖', '🍞', '🥨', '🥯', '🧀', '🥚', '🍳', '🧈',
      '🥞', '🧇', '🥓', '🥩', '🍗', '🍖', '🦴', '🌭', '🍔', '🍟',
      '🍕', '🫓', '🥪', '🥙', '🧆', '🌮', '🌯', '🫔', '🥗', '🥘',
      '🫕', '🍝', '🍜', '🍲', '🍛', '🍣', '🍱', '🥟', '🦪', '🍤'
    ]
  },
  travel: {
    name: 'Travel & Places',
    icon: '✈️',
    emojis: [
      '🚗', '🚕', '🚙', '🚌', '🚎', '🏎️', '🚓', '🚑', '🚒', '🚐',
      '🛻', '🚚', '🚛', '🚜', '🏍️', '🛵', '🚲', '🛴', '🛹', '🛼',
      '🚁', '🛸', '✈️', '🛩️', '🪂', '💺', '🚀', '🛰️', '🚢', '⛵',
      '🚤', '🛥️', '🛳️', '⛴️', '🚂', '🚃', '🚄', '🚅', '🚆', '🚇',
      '🚈', '🚉', '🚊', '🚝', '🚞', '🚋', '🚌', '🚍', '🎡', '🎢',
      '🎠', '🏗️', '🌁', '🗼', '🏭', '⛲', '🎡', '🎢', '🏖️', '🏝️'
    ]
  },
  objects: {
    name: 'Objects',
    icon: '📱',
    emojis: [
      '📱', '💻', '🖥️', '🖨️', '⌨️', '🖱️', '🖲️', '💽', '💾', '💿',
      '📀', '📼', '📷', '📸', '📹', '🎥', '📽️', '🎞️', '📞', '☎️',
      '📟', '📠', '📺', '📻', '🎙️', '🎚️', '🎛️', '🧭', '⏱️', '⏲️',
      '⏰', '🕰️', '⌛', '⏳', '📡', '🔋', '🔌', '💡', '🔦', '🕯️',
      '🪔', '🧯', '🛢️', '💸', '💵', '💴', '💶', '💷', '🪙', '💰'
    ]
  },
  symbols: {
    name: 'Symbols',
    icon: '⭐',
    emojis: [
      '⭐', '🌟', '💫', '✨', '🌠', '🌙', '☀️', '⛅', '⛈️', '🌤️',
      '🌦️', '🌧️', '⛆', '❄️', '☃️', '⛄', '🌈', '🔥', '💧', '🌊',
      '🎵', '🎶', '🎼', '🎹', '🥁', '🎷', '🎺', '🎸', '🪕', '🎻',
      '✅', '❌', '❎', '✔️', '☑️', '🔘', '⚪', '⚫', '🔴', '🟠',
      '🟡', '🟢', '🔵', '🟣', '🟤', '⭕', '🚫', '💯', '💢', '💥'
    ]
  },
  flags: {
    name: 'Flags',
    icon: '🏳️',
    emojis: [
      '🏳️', '🏴', '🏁', '🚩', '🏳️‍🌈', '🏳️‍⚧️', '🇺🇸', '🇬🇧', '🇨🇦', '🇦🇺',
      '🇩🇪', '🇫🇷', '🇮🇹', '🇪🇸', '🇯🇵', '🇰🇷', '🇨🇳', '🇮🇳', '🇧🇷', '🇲🇽',
      '🇷🇺', '🇿🇦', '🇳🇬', '🇪🇬', '🇸🇦', '🇦🇪', '🇹🇷', '🇬🇷', '🇳🇱', '🇸🇪'
    ]
  }
};


export const getAllEmojis = () => {
  const allEmojis = [];
  Object.values(emojiCategories).forEach(category => {
    allEmojis.push(...category.emojis);
  });
  return allEmojis;
};

export const searchEmojis = (query) => {
  if (!query) return getAllEmojis();
  
  const searchTerms = {
    'happy': ['😀', '😃', '😄', '😁', '😆', '😅', '😊', '🙂', '😇', '🥰', '😍', '🤩'],
    'sad': ['😔', '😢', '😭', '😞', '😟', '😕', '🙁', '☹️', '😣', '😖'],
    'love': ['❤️', '💕', '💖', '💗', '💓', '💞', '💘', '💝', '💟', '♥️', '💋', '😍', '🥰'],
    'angry': ['😠', '😡', '🤬', '😤', '💢', '👿', '😾'],
    'surprised': ['😲', '😯', '😮', '😧', '😦', '🤯', '😱'],
    'food': emojiCategories.food.emojis,
    'travel': emojiCategories.travel.emojis,
    'heart': emojiCategories.hearts.emojis,
    'thumbs': ['👍', '👎'],
    'fire': ['🔥'],
    'star': ['⭐', '🌟', '💫', '✨'],
    'money': ['💰', '💵', '💸', '🤑', '💳', '💎'],
    'time': ['⏰', '⏱️', '⏲️', '🕐', '🕑', '🕒', '🕓', '🕔', '🕕']
  };
  
  const lowerQuery = query.toLowerCase();
  const matchedEmojis = [];
  
  Object.entries(searchTerms).forEach(([term, emojis]) => {
    if (term.includes(lowerQuery) || lowerQuery.includes(term)) {
      matchedEmojis.push(...emojis);
    }
  });
  
  if (matchedEmojis.length === 0) {
    return ['😀', '😊', '👍', '❤️', '🔥', '⭐', '🎉', '💯', '🚀', '💪'];
  }
  
  return [...new Set(matchedEmojis)];
};

export const getFrequentlyUsedEmojis = () => {
  return [
    '😀', '😊', '👍', '❤️', '🔥', '⭐', '🎉', '💯', '🚀', '💪',
    '👏', '🙏', '💖', '😍', '🤝', '✅', '🎯', '💡', '🌟', '🎊'
  ];
};

export const getRecentlyUsedEmojis = () => {
  try {
    const recent = localStorage.getItem('recentlyUsedEmojis');
    return recent ? JSON.parse(recent) : [];
  } catch {
    return [];
  }
};

export const addToRecentlyUsed = (emoji) => {
  try {
    let recent = getRecentlyUsedEmojis();
    
    recent = recent.filter(e => e !== emoji);
    
    recent.unshift(emoji);
    
    recent = recent.slice(0, 20);
    
    localStorage.setItem('recentlyUsedEmojis', JSON.stringify(recent));
  } catch {
    
  }
};
