import { API_BASE_URL, API_TOKEN, ENDPOINTS, buildApiUrl } from './apiConfig';
/** 
  * create auto reply
  * @returns {Object} auto reply
  */
 export const createAutoReply = async (createAutoReplyPayload) => {   
  try {
    const url = `https://app.getgabs.com/partners/automation/autoreply/create`;
    const response = await fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
        'Authorization': `Bearer ${API_TOKEN}`,
        'X-Requested-With': 'XMLHttpRequest',

      },
      body: JSON.stringify(createAutoReplyPayload)
    });
    const maybeJson = await response.json().catch(() => null);

    if (!response.ok) {
      const message = (maybeJson && (maybeJson.message || maybeJson.error)) || `HTTP ${response.status}`;
      throw new Error(message);
    }

    const data = maybeJson ?? {};
    const success = data?.status === true || data?.success === true || data?.status === 'success';
    if (!success) {
      throw new Error(data?.message || 'Create auto reply failed');
    }

    console.log('create auto reply', data);
    return data;
  } catch (error) {
    console.error('Error creating auto reply:', error);
    throw error;
  }
};

/** 
  * get auto reply list
  * @returns {Object} auto reply list
  */
export const fetchAutoReplyList = async (options = {}) => {
    const {
      statusType = 'All',
      page = 1,
      perPageData = 10,
      search = '',
      token = API_TOKEN
    } = options;
  
    try {
      const url = new URL('https://app.getgabs.com/partners/automation/autoreply/fetchautoreplies');
      url.searchParams.append('statusType', statusType);
      url.searchParams.append('perPageData', perPageData.toString());
      url.searchParams.append('search', search);
      url.searchParams.append('token', token);
      // You can include page if your API supports it
      if (page) url.searchParams.append('page', page.toString());
  
      const response = await fetch(url.toString(), {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
          'Accept': 'application/json',
        },
      });
  
      if (!response.ok) {
        throw new Error(`HTTP error! Status: ${response.status}`);
      }
  
      const data = await response.json();
      return data;
    } catch (error) {
      console.error('Error fetching auto reply list:', error);
      throw error;
    }
  };


  /** 
 * to delete contactlist
 * @returns {Object} Contact list
 */
export const deleteAutoReply = async (autoReplyId) => { 
  try {
    const url = `https://app.getgabs.com/partners/automation/delete/Autoreply`;
    const response = await fetch(url, {
      method: 'POST',
      headers: {
        'Accept': 'application/json',
        'Authorization': `Bearer ${API_TOKEN}`,
        'X-Requested-With': 'XMLHttpRequest',
      },
      body: JSON.stringify({ id: autoReplyId })
    });
    const maybeJson = await response.json().catch(() => null);

    if (!response.ok) {
      const message = (maybeJson && (maybeJson.message || maybeJson.error)) || `HTTP ${response.status}`;
      throw new Error(message);
    }

    const data = maybeJson ?? {};
    const success = data?.status === true || data?.success === true || data?.status === 'success';
    if (!success) {
      throw new Error(data?.message || 'Delete failed');
    }

    console.log('delete auto reply', data);
    return data;
  } catch (error) {
    console.error('Error deleting auto reply:', error);
    throw error;
  }
};


  